//AIM:Four point IDIF-FFT without using inbuilt Scilab FFT function

//Computing four point IDFT for X(k)={10,-2+2j,-2,-2-2j} using 
//Inverse Decimation in Frequency-Fast Fourier transform (i.e. IDIF-FFT )
//without using readymade inbuilt Scilab functions for IDFT/IFFT.

//Software version Scilab 5.5.2
//OS windows 10
clc;
clear;
//Let us begin with the programming.For understanding,let us write the given
//data as
//X(0)=10;X(1)=-2+2j,X(2)=-2,X(3)=-2-2j
X0c=10;//X0c means complex conjugate of XO
X1c=(-2)+((-1)*(2)*(sqrt(-1)));//X1c means complex conjugate of X1
X2c=-2;//X2c means complex conjugate of X2
X3c=(-2)-((-1)*(2)*(sqrt(-1)));//X3c means complex conjugate of X3
disp(X0c,'X*(0)=')
disp(X1c,'X*(1)=')
disp(X2c,'X*(2)=')
disp(X3c,'X*(3)=')
x0_star=((X3c+X1c)*(1)+(X2c+X0c)*(1))*(1/4);//Computing x*(0)
disp(x0_star,'x*(0)=')
x2_star=((((X3c+X1c)*(1))-((X2c+X0c)*(1)))*(-1))*(1/4);//Computing x*(2)
disp(x2_star,'x*(2)=')
x1_star=((X3c-X1c)*(-1)*(-sqrt(-1))+(X2c-X0c)*(-1))*(1/4);//Computing x*(1)
disp(x1_star,'x*(1)=')
//Computing x*(3)
x3_star=((((X3c-X1c)*(-1)*(-sqrt(-1))-(X2c-X0c)*(-1)))*(-1))*(1/4);
disp(x3_star,'x*(3)=')
disp({,x0_star,x1_star,x2_star,x3_star,},'x*(n)=')
//The computed value is x*(n). But we need x(n) as final output.
//We will separate real part of x*(n)
//We will separate imaginary part of x*(n) and take its complex conjugate by
//multiplying by a factor of (-1)
x0_star_real=real(x0_star);
x0_star_conj=(-1)*(imag(x0_star));
x1_star_real=real(x1_star);
x1_star_conj=(-1)*(imag(x1_star));
x2_star_real=real(x2_star);
x2_star_conj=(-1)*(imag(x2_star));
x3_star_real=real(x3_star);
x3_star_conj=(-1)*(imag(x3_star));
//Finally, we will add the real part and the imaginary part whose complex
//conjugate is taken to get xx(0),(1),x(2) and x(3)
x0=x0_star_real+x0_star_conj;//Computing x(0)
x1=x1_star_real+x1_star_conj;//Computing x(1)
x2=x2_star_real+x2_star_conj;//Computing x(2)
x3=x3_star_real+x3_star_conj;//Computing x(3)
disp({,x0,x1,x2,x3,},'So,the IDFT of X(k) using Inverse Decimation-in-Frequency Fast Fourier Transform(IDIF-FFT) is x(n)=')
